function [r,tau,phir,phitau]=factrtau(sys,TES)
% FACTRTAU retourne les facteurs de rflexion et de transmission
%   en terme de fonctions d'onde pour un objet soumis  une
%   nergie potentielle quelconque compose de discontinuits (objet
%   marche). Les phases de ces facteurs sont galement donnes
%   entre 0 et 2*pi.
%   [r,tau,phir,phitau]=FACTRTAU(sys)
%       >> sys      = nergie potentielle;
%       << r        = facteur de rflexion en fonctions d'onde;
%       << tau      = facteur de transmission en fonctions d'onde.
%       << phir     = phase  la rflexion;
%       << phitau   = phase  la transmission.
%
%   Olivier Pujol : septembre 2013
%
if (nargin~=2),error('Mauvais nombre d''arguments d''entre !');end
%
nE=size(TES,2); % Nombre de valeurs de l'nergie
r=nan(1,nE);
tau=nan(1,nE);
phir=nan(1,nE);
phitau=nan(1,nE);
%
for iE=1:nE
    r(iE)=-TES{iE}(2,1)/TES{iE}(2,2);
    tau(iE)=sqrt(sys{iE}{1}(3)/sys{iE}{1}(4))*(1/TES{iE}(2,2));
    phir(iE)=mod(angle(r(iE)),pi);
    phitau(iE)=mod(angle(tau(iE)),pi);
end
%
return;
